unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TMainForm = class(TForm)
    InpComboDlgButton: TButton;
    LanguageCombo: TComboBox;
    DebugMemo: TMemo;
    NextButton: TButton;
    procedure FormCreate(Sender: TObject);
    procedure InpComboDlgButtonClick(Sender: TObject);
    procedure LanguageComboChange(Sender: TObject);
    procedure NextButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses
  InpComboDlgUnit, MyControls;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
var
  sr: TSearchRec;
begin
  if FindFirst('language\*.lng', faAnyFile, sr)=0 then begin
    repeat
      LanguageCombo.Items.Add(sr.Name);
    until FindNext(sr)<>0;
    FindClose(sr);
  end;
  LanguageCombo.ItemIndex:=0;
end;

procedure TMainForm.InpComboDlgButtonClick(Sender: TObject);
begin
  InpComboDlg.Show;
end;

procedure TMainForm.LanguageComboChange(Sender: TObject);
begin
  LoadTranslation('language\'+LanguageCombo.Text);
  //DebugMemo.Lines.Add(GetTranslation(5002));
  InpComboDlg.UpdateTranslation;
end;

procedure TMainForm.NextButtonClick(Sender: TObject);
var
  i: Integer;
begin
  i:=LanguageCombo.ItemIndex+1;
  if i>LanguageCombo.Items.Count-1 then i:=0;
  LanguageCombo.ItemIndex:=i;
  LanguageComboChange(nil);
end;

end.
